/**
* \file: AilAudioOutImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AILAUDIOOUTIMPL_H
#define CARPLAY_AILAUDIOOUTIMPL_H

#include <atomic>
#include <string>
#include <vector>
#include <memory>
#include <carplay_plugin.h>
#include "AudioStreaming.h"


namespace adit { namespace utility { namespace audio
{
class Backend;
class StreamStatistics;
};};};

namespace adit { namespace carplay
{
using namespace adit::utility::audio;
using namespace adit::utility;

class AilAudioOut::Impl : public IAudioOutAdapter, public Streaming
{
public :
    Impl();
    virtual ~Impl();

    // IAudioOutAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioOutSource& inSource);
    virtual bool Prepare(AudioFormatStruct inFormat, AudioChannelType inChannel, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();
    virtual void Flush();

    // private section
private:
    const IConfiguration* config;

    IAudioOutSource* source;

    std::string deviceName;

    uint32_t periodMilli;
    uint32_t periodSamples;
    uint32_t appendEmptyPeriods;
    AudioFormatStruct format;

    AudioChannelType channel;

    std::atomic_bool running;
    bool verboseLogging;

    Samples samples;
    std::shared_ptr<uint8_t> dataPtr;
    uint64_t sampleNumber;

    std::shared_ptr<Backend> backend;

    bool parseDeviceSettings();
    bool getDeviceName(AudioChannelType inChannel, std::string& outDeviceName);
    int getPeriodMilli(const std::string& inDeviceName, int inSampleRate);
    bool getDeviceSettings(const std::string& inAudioType);

    /* Streaming callbacks */
    void error(const std::string& data) const final;
    void warning(const std::string& data) const final;
    void info(const std::string& data) const final;
    void debug(const std::string& data) const final;
    eLogLevel checkLogLevel() const final;

    AudioState processing(unsigned char *in, unsigned char **out, uint32_t &frames) final;
    void statistics(const StreamStatistics &status) final;
    void eostreaming(const AudioError error) final;

};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AILAUDIOOUTIMPL_H */
